/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.cf3270em;

import com.ibm.hwmca.base.cf3270em.Cf3270EmErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.tasklet.PanelTask;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;

public class Cf3270EmTask
extends PanelTask
implements Cf3270EmErrorIds {
    private static final String TRACE_MASKT = "XEMU   T";
    private static final String TRACE_MASKF = "XEMU   F";
    private static final String TRACE_MASKD = "XEMU   D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-93, "Cf3270EmTask");
    private static String tasklet = "com.ibm.hwmca.base.cf3270em.Cf3270EmTasklet";

    public Cf3270EmTask(PresentationTaskParms parms) throws TaskletException, RemoteException {
        super(parms, tasklet);
    }

    public static boolean validIp(String ip) {
        Trace.trace(TRACE_MASKT, "[CF3270EmTask] <--> validIp(" + ip + ")");
        if (ip == null || ip.length() == 0) {
            return false;
        }
        if (ip.equals("255.255.255.255") || ip.equals("0.0.0.0")) {
            return false;
        }
        int i = ip.indexOf("@");
        if (i != -1) {
            ip = ip.substring(i + 1);
        }
        if ((i = ip.indexOf(":")) != -1) {
            String port = ip.substring(i + 1);
            ip = ip.substring(0, i);
            try {
                int p = Integer.parseInt(port);
                if (p < 1 || p > 65536) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        try {
            InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return true;
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "[Cf3270EmTask] --> logException(" + throwable + ")");
        new FrameworkLog(logInfo, 4, throwable).log();
        Trace.trace(TRACE_MASKT, "[Cf3270EmTask] <-- logException()");
    }
}

